// esp8266_MQTT_ldr_01.ino
// https://wiki.binefa.cat

#include <ESP8266WiFi.h>
#include <WiFiClient.h>

#include <PubSubClient.h>

#include "esp8266_hw.h"
#include "wifiCredentials.h"
#include "mqttCredentials.h"

WiFiClient espClient;
PubSubClient client(espClient);

const byte button = 4;

boolean bWifiConnected = false;

void vLed(char cColor, bool bState) {
  switch (cColor) {
    case 'w':
    case 'W': digitalWrite(GPIO2, !bState);
      break;
    case 'r':
    case 'R': digitalWrite(GPIO15, bState);
      break;
    case 'g':
    case 'G': digitalWrite(GPIO12, bState);
      break;
    case 'b':
    case 'B': digitalWrite(GPIO13, bState);
      break;

  }
}

void callback(char* topic, byte* payload, unsigned int length) {
  String szRx = "", szTema(topic);

  Serial.print("Message arrived [");
  Serial.print(topic);
  Serial.print("] ");
  for (int i = 0; i < length; i++) {
    char receivedChar = (char)payload[i];
    szRx += receivedChar;
  }
  Serial.println(szRx);
  if (szTema == TEMA_SUBSCRIPCIO_ESTAT_LEDS) {
    if (szRx == "2L" || szRx == "R1L" ) vLed('g', false);
    if (szRx == "2H" || szRx == "R1H") vLed('g', true);
    if (szRx == "12L" || szRx == "R2L") vLed('y', false);
    if (szRx == "12H" || szRx == "R2H") vLed('y', true);
    if (szRx == "13L" || szRx == "R3L") vLed('r', false);
    if (szRx == "13H" || szRx == "R3H") vLed('r', true);
    if (szRx == "15L" || szRx == "R4L" ) vLed('w', false);
    if (szRx == "15H" || szRx == "R4H") vLed('w', true);
  }
}

void reconnect() {
  setup_wifi();
  client.setServer(mqtt_server, mqtt_port);
  client.setCallback(callback);
  // Loop until we're reconnected
  while (!client.connected()) {
    Serial.print("Attempting MQTT connection...");
    // Attempt to connect
    if (client.connect(NODE_UNIQUE_NAME)) {
      Serial.println("connected");
      // ... and subscribe to topic
      client.subscribe(TEMA_SUBSCRIPCIO_ESTAT_LEDS);
    } else {
      Serial.print("failed, rc=");
      Serial.print(client.state());
      Serial.println(" try again in 5 seconds");
      // Wait 5 seconds before retrying
      vDelayESP(5000);
    }
  }
}

//  WiFi{
void vDelayESP(unsigned long ulMilliseconds) {
  unsigned long ulPreviousMillis = millis();

  do {
    yield();
  } while (millis() - ulPreviousMillis <= ulMilliseconds);
}

void vConnectToWiFi(const char* szSsid, const char* szPwd) {
  char ssid[MAX_STRING_SIZE],  pwd[MAX_STRING_SIZE];

  Serial.println("Connecting to WiFi network: " + String(szSsid) + ", pwd: " + String(szPwd));

  WiFi.begin(szSsid, szPwd);

  Serial.println("Waiting for WIFI connection...");
  while (WiFi.status() != WL_CONNECTED /*&& i++ < 20*/) {
    Serial.print(".");
    vDelayESP(500);
  }
  Serial.println();
}

boolean bIsListed(String szSSID, int *pNwO) {
  for (int i = 0; i < N_WIFIS ; i++) {
    if (String(stWiFi[i].szSSID) == szSSID) {
      *pNwO = i;
      return true;
    }
  }
  return false;
}

boolean bTryWifiConnection() {
  int n = WiFi.scanNetworks(), nWhichOne;

  //Serial.print("*");
  if (n == 0) {
    Serial.println("\nNo networks found");
    vDelayESP(1000);
  } else {
    for (int i = 0; i < n; ++i) {
      if (bIsListed(WiFi.SSID(i), &nWhichOne)) {
        vConnectToWiFi(stWiFi[nWhichOne].szSSID, stWiFi[nWhichOne].szPWD);
        return true;
      }
    }
  }
  return false;
}

void setup_wifi() {
  do {
    WiFi.mode(WIFI_STA);
    WiFi.disconnect();
    vDelayESP(100);
  } while (!bTryWifiConnection());
  IPAddress ip = WiFi.localIP();
  Serial.print("Connected to wifi at "); Serial.println(ip);
}

// }WiFi



void setup() {
  pinMode(GPIO2, OUTPUT); // Internal blue led
  pinMode(GPIO15, OUTPUT); // Red of RGB led
  pinMode(GPIO13, OUTPUT); // Blue of RGB led
  pinMode(GPIO12, OUTPUT); // Green of RGB led

  Serial.begin(115200);

  setup_wifi();
}

void loop() {
  boolean bButtonState = !digitalRead(button);
  static boolean bLastButtonState = bButtonState;
  char sz[33];

  if (!client.connected()) {
    reconnect();
  }

  if (bButtonState != bLastButtonState) {
    bLastButtonState = bButtonState;
    vDelayESP(50);
    if (!bButtonState)
      client.publish(TEMA_PUBLICA_ESTAT_BOTO, "Unpressed button");
    else
      client.publish(TEMA_PUBLICA_ESTAT_BOTO, "Pressed button");
  }

  //if (!(millis() / 1000))
  //  if (!((millis() / 1000) % 5)) {
      sprintf(sz, "%d", analogRead(A0));
      client.publish(TEMA_PUBLICA_NIVELL_LDR, sz);
      Serial.println(sz);
  //  }

  client.loop();
  vDelayESP(5000);
}

