#include "provajson.h"
#include "ui_provajson.h"

#include <QDebug>
#include <QJsonDocument>

ProvaJson::ProvaJson(QWidget *parent)
    : QWidget(parent)
    , ui(new Ui::ProvaJson)
{
    ui->setupUi(this);

    qjoJson = new QJsonObject;
    QJsonObject qjoL;

    qjoL["campText"] = "Un text qualsevol";
    qjoL["campNum"] = 234;

    *qjoJson = qjoL;

    ui->lbText->setText(qjoL["campText"].toString());
    ui->lbNum->setText(trUtf8("%1").arg(qjoL["campNum"].toInt()));

    QString strFromObj = QJsonDocument(qjoL).toJson(QJsonDocument::Compact).toStdString().c_str();
    ui->lbJson->setText(strFromObj);


//    QJsonObject object
//    {
//        {"property1", 1},
//        {"property2", 2}
//    };
}

ProvaJson::~ProvaJson()
{
    delete ui;
}

/*
QJsonArray jsonArray;
    jsonArray = jsonObj["Phone numbers"].toArray();

    for(int i = 0; i < jsonArray.size(); i++)
        textStream << jsonArray[i].toString() << endl;

    textStream << "or with foreach" << endl;

    foreach(QJsonValue v, jsonArray)
        textStream << v.toString() << endl;

*/

void ProvaJson::on_btEscriu_clicked(){
    QJsonObject qjoL;

    qjoL["campText"] = ui->letext->text();
    qjoL["campNum"] = ui->leNum->text().toInt();

    *qjoJson = qjoL;

    QString strFromObj = QJsonDocument(qjoL).toJson(QJsonDocument::Compact).toStdString().c_str();
    ui->lbJson->setText(strFromObj);
    qDebug() << strFromObj;
}

void ProvaJson::on_btLlegeix_clicked(){
    QJsonObject qjoL = *qjoJson;

    ui->lbText->setText(qjoL["campText"].toString());
    ui->lbNum->setText(trUtf8("%1").arg(qjoL["campNum"].toInt()));

}
