#include "panell.h"
#include "ui_panell.h"
#include <QDebug>

Panell::Panell(QWidget *parent)
    : QWidget(parent)
    , ui(new Ui::Panell)
{
    ui->setupUi(this);

    m_client = new QMqttClient(this);
    m_client->setHostname(ui->lineEditUrlBroker->text());
    m_client->setPort(ui->lineEditBrokerPort->text().toInt());

    connect(m_client, &QMqttClient::stateChanged, this, &Panell::updateLogStateChange);
    connect(m_client, &QMqttClient::disconnected, this, &Panell::brokerDisconnected);

}

Panell::~Panell()
{
    delete ui;
}

void Panell::on_btConnect_clicked()
{
    if (m_client->state() == QMqttClient::Disconnected) {
        ui->lineEditUrlBroker->setEnabled(false);
        ui->lineEditBrokerPort->setEnabled(false);
        ui->btConnect->setText("&Disconnect");
        m_client->connectToHost();
    } else {
        ui->lineEditUrlBroker->setEnabled(true);
        ui->lineEditBrokerPort->setEnabled(true);
        ui->btConnect->setText("&Connect");
        m_client->disconnectFromHost();
    }
}

void Panell::updateLogStateChange()
{
    const QString content = QDateTime::currentDateTime().toString()
                    + QLatin1String(": State Change")
                    + QString::number(m_client->state())
                    + QLatin1Char('\n');
    ui->plainTextEdit->insertPlainText(content);
    qDebug() << content;
}

void Panell::brokerDisconnected()
{
    ui->lineEditUrlBroker->setEnabled(true);
    ui->lineEditBrokerPort->setEnabled(true);
    ui->btConnect->setText(tr("&Connect"));
}
