#include "frontal.h"
#include "ui_frontal.h"
#include <QTimer>
#include <QDebug>

Frontal::Frontal(QWidget *parent)
    : QWidget(parent)
    , ui(new Ui::Frontal)
{
    ui->setupUi(this);

    QTimer *timer = new QTimer(this);
    connect(timer, SIGNAL(timeout()), this, SLOT(vActualitza()));
    timer->start(1000);

    ui->label_R->setStyleSheet("QLabel { color : darkred; }");
    ui->label_G->setStyleSheet("QLabel { color : darkgreen; }");
}

Frontal::~Frontal()
{
    delete ui;
}

void Frontal::vActualitza(){
    if(ui->label_Rebut->text() == "Premut")
        ui->label_Rebut->setText("No premut");
    else
        ui->label_Rebut->setText("Premut");
}

void Frontal::on_btR_clicked(bool checked)
{
    QString qszColor = checked ? "QLabel { color : red; }":"QLabel { color : darkred; }";
    ui->label_R->setStyleSheet(qszColor);
    qDebug() << qszIpPort() + (checked ? " R":" r");
}

void Frontal::on_btG_clicked(bool checked)
{
    QString qszColor = checked ? "QLabel { color : lime; }":"QLabel { color : darkgreen; }";
    ui->label_G->setStyleSheet(qszColor);
    qDebug() << qszIpPort() + (checked ? " G":" g");
}

QString Frontal::qszIpPort(){
    return ui->lineEdit_IP->text() + ":" + ui->lineEdit_Port->text();
}
