#ifndef GINYUDPTRAMET_H
#define GINYUDPTRAMET_H

#include <QWidget>

namespace Ui {
class GinyUdpTramet;
}

class GinyUdpTramet : public QWidget
{
    Q_OBJECT

public:
    explicit GinyUdpTramet(QWidget *parent = nullptr);
    ~GinyUdpTramet();

protected slots:
    void vSendUdpDatagram();
    void vRemoveInfo();

private slots:
    void on_btSend_clicked();

    void on_lePort_textChanged(const QString &arg1);

    void on_cbR_clicked(bool checked);

    void on_cbG_clicked(bool checked);

    void on_cbB_clicked(bool checked);

    void on_cbLittleB_clicked(bool checked);

private:
    Ui::GinyUdpTramet *ui;
    QStringList qslDNSResolver(QString host);
    bool bSendUdpByteArray(QByteArray);

signals:
    void vTrametRxUdpPort(int);

};

#endif // GINYUDPTRAMET_H
