#include "ginyudptramet.h"
#include "ui_ginyudptramet.h"

#include <QDebug>
#include <QUdpSocket>
#include <QHostAddress>
#include <QTimer>

#include <QHostInfo>

GinyUdpTramet::GinyUdpTramet(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::GinyUdpTramet)
{
    ui->setupUi(this);
    ui->leText->selectAll();
    ui->leText->setFocus();
    ui->lbInfo->setText(" ");
    ui->leDN->setDisabled(true);
}

GinyUdpTramet::~GinyUdpTramet()
{
    delete ui;
}

void GinyUdpTramet::on_btSend_clicked()
{
    //qDebug() << ui->leText->text();
    vSendUdpDatagram();
}

QStringList GinyUdpTramet::qslDNSResolver(QString host)
{
    QHostInfo hostInfo;
    QHostInfo returnedHost = hostInfo.fromName(host);
    QStringList list;

    if (returnedHost.error() != QHostInfo::NoError) {
         qDebug() << "Lookup failed:" << returnedHost.errorString();
    }else
        foreach (const QHostAddress &address, returnedHost.addresses())
        {
              list<<address.toString();
        }

    return list;
}

bool GinyUdpTramet::bSendUdpByteArray(QByteArray qba){
    QUdpSocket *udpSendingSocket = new QUdpSocket(this);
    bool bSuccessfullySent = false;

    if (ui->radioButtonBroadcast->isChecked()){
        bSuccessfullySent = udpSendingSocket->writeDatagram(qba,QHostAddress::Broadcast,ui->lePort->text().toInt());
    }

    if(ui->radioButtonSingle->isChecked())
        bSuccessfullySent = udpSendingSocket->writeDatagram(qba,QHostAddress(ui->leIP->text()),ui->lePort->text().toInt());
        //bSuccessfullySent = udpSendingSocket->writeDatagram(qba,QHostAddress("esp8266-dam-00.local"),ui->lePort->text().toInt());

    if(ui->radioButtonSingleDN->isChecked()){
        QString qsz = ui->leDN->text();
        QStringList qsl(qslDNSResolver(qsz));
        QHostAddress qha(qsz);

        qDebug() << QString::number(qsl.length());

        if(qsl.length())
            for ( const auto& i : qsl  ){
                qha.setAddress(i);
                if(i.contains(".")){
                    qDebug() << qha.toString();
                    bSuccessfullySent = udpSendingSocket->writeDatagram(qba,qha,ui->lePort->text().toInt());
                    break;
                }
            }
    }
    if(bSuccessfullySent){
        //ui->lbInfo->setStyleSheet("QLabel { background-color : green; color : blue; }");
        ui->lbInfo->setStyleSheet("QLabel { color : green; }");
        ui->lbInfo->setText("UDP successfully sent");
    }else{
        //ui->lbInfo->setStyleSheet("QLabel { background-color : red; color : blue; }");
        ui->lbInfo->setStyleSheet("QLabel { color : red; }");
        ui->lbInfo->setText("UDP has not been sent");
    }
    QTimer::singleShot(1000, this, SLOT(vRemoveInfo()));
    return bSuccessfullySent;
}

void GinyUdpTramet::vRemoveInfo(){
    ui->lbInfo->setText(" ");
}

void GinyUdpTramet::on_lePort_textChanged(const QString &arg1){
    emit vTrametRxUdpPort(arg1.toInt()-1); // PortRx = PortTx-1 in this device
}

void GinyUdpTramet::vSendUdpDatagram(){
    bSendUdpByteArray(ui->leText->text().toLatin1());
}

void GinyUdpTramet::on_cbR_clicked(bool checked){
    bSendUdpByteArray(checked?"15H":"15L");
}

void GinyUdpTramet::on_cbG_clicked(bool checked){
    bSendUdpByteArray(checked?"13H":"13L");
}

void GinyUdpTramet::on_cbB_clicked(bool checked){
    bSendUdpByteArray(checked?"12H":"12L");
}

void GinyUdpTramet::on_cbLittleB_clicked(bool checked){
    bSendUdpByteArray(checked?"2L":"2H");
}
