#include "ginytx.h"
#include "ui_ginytx.h"

#include <QUdpSocket>
#include <QTimer>

GinyTx::GinyTx(QWidget *parent)
    : QWidget(parent)
    , ui(new Ui::GinyTx)
{
    ui->setupUi(this);
}

GinyTx::~GinyTx()
{
    delete ui;
}

bool GinyTx::bSendUdpByteArray(QByteArray qba){
    QUdpSocket *udpSendingSocket = new QUdpSocket(this);
    bool bSuccessfullySent = false;

    bSuccessfullySent = udpSendingSocket->writeDatagram(qba,QHostAddress(ui->lineEditIP->text()),ui->lineEditPort->text().toInt());

    if(bSuccessfullySent){
        //ui->lbInfo->setStyleSheet("QLabel { background-color : green; color : blue; }");
        ui->etInfo->setStyleSheet("QLabel { color : green; }");
        ui->etInfo->setText("UDP successfully sent");
    }else{
        //ui->lbInfo->setStyleSheet("QLabel { background-color : red; color : blue; }");
        ui->etInfo->setStyleSheet("QLabel { color : red; }");
        ui->etInfo->setText("UDP has not been sent");
    }
    QTimer::singleShot(1000, this, SLOT(vRemoveInfo()));
    return bSuccessfullySent;
}

void GinyTx::on_btR_clicked(bool checked)
{
    bSendUdpByteArray(checked?"15H":"15L");
}

void GinyTx::on_cbG_clicked(bool checked)
{
    bSendUdpByteArray(checked?"13H":"13L");
}

void GinyTx::on_cbB_clicked(bool checked)
{
    bSendUdpByteArray(checked?"12H":"12L");
}

void GinyTx::on_cb_b_clicked(bool checked)
{
    bSendUdpByteArray(checked?"2L":"2H");
}

void GinyTx::vRemoveInfo(){
    ui->etInfo->setText(" ");
}
