import QtQuick 2.13
import QtQuick.Controls 2.13

import desDel.rerefons 1.0

ApplicationWindow {
    visible: true
    width: 500
    height: 400
    title: qsTr("2partQml")

    RereFons{
        id: rf
    }

    SwipeView {
        id: swipeView
        anchors.fill: parent
        currentIndex: tabBar.currentIndex

        Page1Form {
            id: p1f
        }

        ControlUdp {
            btR.onAreaRatoliClicked: {
                //console.log("R")
                if(indicadorR.color == "#8b0000"){
                    indicadorR.color = "#ff0000"
                    rf.szCadena = p1f.textInputIP.text + ":"+ p1f.textInputPort.text +" R"
                 }else{
                    indicadorR.color = "#8b0000"
                    rf.szCadena = p1f.textInputIP.text + ":"+ p1f.textInputPort.text +" r"
                 }
            }
            btG.onAreaRatoliClicked: {
                //console.log("G")
                if(indicadorG.color == "#006400"){
                    indicadorG.color = "#00ff00"
                    rf.szCadena = p1f.textInputIP.text + ":"+ p1f.textInputPort.text +" G"
                }else{
                    indicadorG.color = "#006400"
                    rf.szCadena = p1f.textInputIP.text + ":"+ p1f.textInputPort.text +" g"
                }
            }
            txtRebut: rf.szTxtRebut
        }

    }

    footer: TabBar {
        id: tabBar
        currentIndex: swipeView.currentIndex

        TabButton {
            text: qsTr("Settings")
        }
        TabButton {
            text: qsTr("Control")
        }
    }
}
