import QtQuick 2.13
import QtQuick.Controls 2.13
import QtQuick.Layouts 1.0

Page {
    id: page
    width: 600
    height: 400
    property alias textInputPort: textInputPort
    property alias textInputIP: textInputIP
    transformOrigin: Item.Right

    Text {
        id: etIP
        y: 154
        color: "#0000ff"
        text: qsTr("IP: ")
        anchors.leftMargin: parent.width/5
        anchors.left: parent.left
        anchors.verticalCenterOffset: -30
        anchors.verticalCenter: parent.verticalCenter
        Layout.rowSpan: 10
        font.bold: true
        horizontalAlignment: Text.AlignRight
        font.pixelSize: 44
    }

    TextInput {
        id: textInputIP
        x: 438
        y: 190
        text: qsTr("127.0.0.1")
        anchors.verticalCenterOffset: -30
        anchors.verticalCenter: parent.verticalCenter
        anchors.left: etIP.right
        Layout.preferredHeight: 20
        Layout.preferredWidth: 80
        cursorVisible: true
        inputMask: "000.000.000.000"
        font.bold: true
        font.family: "Verdana"
        font.pixelSize: 44
    }

    Text {
        id: etPort
        x: 247
        y: 112
        color: "#0000ff"
        text: qsTr("Port: ")
        anchors.left: parent.left
        anchors.verticalCenterOffset: 30
        font.pixelSize: 44
        font.bold: true
        anchors.verticalCenter: parent.verticalCenter
        horizontalAlignment: Text.AlignRight
        anchors.leftMargin: parent.width/5
        Layout.rowSpan: 10
    }

    TextInput {
        id: textInputPort
        x: 429
        y: 181
        text: qsTr("7777")
        anchors.left: etPort.right
        anchors.verticalCenterOffset: 30
        font.pixelSize: 44
        font.bold: true
        cursorVisible: true
        anchors.verticalCenter: parent.verticalCenter
        Layout.preferredHeight: 20
        Layout.preferredWidth: 80
        font.family: "Verdana"
        inputMask: ""
    }




}


/*##^##
Designer {
    D{i:1;anchors_x:125}D{i:3;anchors_x:125}
}
##^##*/
