import QtQuick 2.13
import QtQuick.Window 2.13

Window {
    visible: true
    width: 960
    height: 240
    property alias elementTxt: elementTxt
    //title: qsTr("Canviem el títol de la finestra")

    Rectangle {
        id: rectangle
        anchors.fill: parent
        focus: true
        gradient: Gradient {
            GradientStop {
                position: 0
                color: "#eee467"
            }

            GradientStop {
                position: 1
                color: "#0cdbf3"
            }
        }

        Cercle {
            id: cercle
            x: 314
            y: 120
            anchors.right: parent.right
            anchors.rightMargin: 200
            anchors.verticalCenter: parent.verticalCenter
            elementTextCercle.text: "Dreta"
            //rectangle.color: "#0000FF"
            displayColor: "#0000FF"
            area.onClicked: {
                console.log("Dreta")
                cercleEsq.visible = !cercleEsq.visible
            }
        }

        Cercle {
            id: cercleEsq
            y: 120
            anchors.left: parent.left
            anchors.leftMargin: 200
            anchors.verticalCenter: parent.verticalCenter
            elementTextCercle.text: "Esquerra"
            displayColor: "#FF0000"
            // rectangle.color: "#FF0000"
            area.onClicked: {
                console.log("Esquerra premut")
                cercle.visible = !cercle.visible

            }
            area.onPressed: {
                displayColor = "blue"
            }
            area.onReleased:{
                console.log("Esquerra despremut")
                displayColor = "red"
            }
        }

        Text {
            id: elementTxt
            x: 308
            y: 232
            color: "#f73333"
            text: "Un text"
            anchors.horizontalCenter: parent.horizontalCenter
            anchors.verticalCenter: parent.verticalCenter
            font.weight: Font.Bold
            font.family: "Arial"
            horizontalAlignment: Text.AlignHCenter
            font.pixelSize: 36
        }


        Keys.onPressed: {
            // Llistat de tecles: https://doc.qt.io/qt-5/qt.html#Key-enum
            if (event.key === Qt.Key_Plus ) {
                elementTxt.font.pixelSize++;
                // console.log('+');
            }
            if (event.key === Qt.Key_Minus ) {
                elementTxt.font.pixelSize--;
                // console.log('-');
            }
            if (event.key === Qt.Key_C ) {
                elementTxt.rotation += 10;
                // console.log('-');
            }
            if (event.key === Qt.Key_R ) {
                elementTxt.rotation -= 10;
                // console.log('-');
            }
        }
    }
}

/*##^##
Designer {
    D{i:1;anchors_height:200;anchors_width:200;anchors_x:164;anchors_y:146}
}
##^##*/
