#include "ginyencapsulabarres.h"
#include "ui_ginyencapsulabarres.h"

GinyEncapsulaBarres::GinyEncapsulaBarres(QWidget *parent)
    : QWidget(parent)
    , ui(new Ui::GinyEncapsulaBarres)
{
    ui->setupUi(this);

    gbPV = new GinyBarraProgresVertical;
    gbPH = new GinyBarraProgresHoritzonal;

    ui->distEsq->addWidget(gbPV);
    ui->distDre->addWidget(gbPH);

    nValue = VALOR_INICIAL;
    gbPV->vSlotSetNum(nValue);
    gbPH->vSlotSetNum(nValue);
    vSlotEmplenaLineEdit(nValue);

    connect(gbPV,SIGNAL(vSenyalNumCanviat(int)),
            gbPH,SLOT(vSlotSetNum(int)));
    connect(gbPH,SIGNAL(vSenyalNumCanviat(int)),
            gbPV,SLOT(vSlotSetNum(int)));
    connect(gbPV,SIGNAL(vSenyalNumCanviat(int)),
            this,SLOT(vSlotEmplenaLineEdit(int)));
    connect(ui->leNum,SIGNAL(textChanged(QString)),
            this,SLOT(vSlotActualitzaBarres(QString)));
}

GinyEncapsulaBarres::~GinyEncapsulaBarres()
{
    delete ui;
}

void GinyEncapsulaBarres::vSlotEmplenaLineEdit(int n){
    ui->leNum->setText(QString::number(n));
}

void GinyEncapsulaBarres::vSlotActualitzaBarres(QString qsz){
    bool bOk;

    nValue = qsz.toInt(&bOk);
    if(bOk)
        if(nValue >= 0 && nValue <= 100)
            gbPV->vSlotSetNum(nValue);
}
