/**
 * Copyright 2024 Derya Y. (iot.redplc@gmail.com).
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 **/

"use strict";

module.exports = function (RED) {

    const syslib = require('./lib/syslib.js');

    RED.nodes.registerType("redplc-import", function (n) {
        const node = this;
        RED.nodes.createNode(node, n);

        node.varname = n.vartype + n.address;
        node.index = n.index;
        node.name = node.varname + "." + n.index;
        node.tofix = n.tofix;
        node.iserror = false;

        syslib.setStatus(node, node.name);

        node.on("input", (msg) => {
            if (node.iserror)
                return;

            if (node.ctxvar === undefined) {
                node.ctxvar = syslib.getVariable(node, node.varname, node.index);

                if (node.ctxvar === undefined) {
                    node.iserror = true;
                    return;
                }
            }
            
            if ((n.vartype == "Q") || (n.vartype == "M")) {
                if (typeof msg.payload == "boolean") {
                    node.ctxvar[node.index] = msg.payload;
                    syslib.setStatusBool(node, node.ctxvar[node.index], node.name + " : " + Number(node.ctxvar[node.index]));
                }
                else
                    syslib.outError(node, "not boolean");
            }
            else {
                if (typeof msg.payload == "number") {
                    node.ctxvar[node.index] = syslib.toFixed(msg.payload, node.tofix);
                    syslib.setStatusBool(node, true, node.name + " : " + node.ctxvar[node.index]);
                }
                else
                    syslib.outError(node, "not number");
            }
        });
    });
}