/**
 * Copyright 2024 Derya Y. (iot.redplc@gmail.com).
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 **/

"use strict";

module.exports = function (RED) {

    const syslib = require('./lib/syslib.js');

    RED.nodes.registerType("redplc-export", function (n) {
        const node = this;
        RED.nodes.createNode(node, n);

        node.varname = n.vartype + n.address;
        node.index = syslib.getIndex(n.vartype, n.index, n.counter, n.timer, n.fflop);
        node.name = node.varname + "." + syslib.getIndexName(n.vartype, n.index, n.counter, n.timer, n.fflop);
        node.topic = n.topic.trim();
        node.label = n.label.trim();
        node.tofix = n.tofix;
        node.ostring = n.ostring;
        node.onwork = false;
        node.iserror = false;

        syslib.setStatus(node, node.name);

        function update() {
            if (node.preval !== node.ctxvar[node.index]) {
                node.preval = node.ctxvar[node.index];

                var outval;

                if (typeof node.ctxvar[node.index] == "boolean") {
                    outval = node.ctxvar[node.index];
                    syslib.setStatusBool(node, node.ctxvar[node.index], node.name + " : " + Number(outval));

                    if (node.ostring)
                        outval = String(Number(outval));
                }
                else {
                    outval = syslib.toFixed(node.ctxvar[node.index], node.tofix);
                    syslib.setStatusBool(node, true, node.name + " : " + outval);

                    if (node.ostring)
                        outval = String(outval);
                }
               
                node.send([null, { payload: outval, topic: node.topic, label: node.label }]);
            }

            node.onwork = false;
        }

        node.on("input", (msg) => {
            var payload_in = syslib.getPayloadBool(node, msg);

            if (payload_in === undefined)
                return;

            if (node.ctxvar === undefined) {
                node.ctxvar = syslib.getVariable(node, node.varname, node.index);

                if (node.ctxvar === undefined) {
                    node.iserror = true;
                    node.send([msg, null]);
                    return;
                }
            }

            if (payload_in === true)
                update();

            node.send([msg, null]);
        });
    });
}