/**
 * Copyright 2024 Derya Y. (iot.redplc@gmail.com).
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 **/

"use strict";

module.exports = function (RED) {

    const syslib = require('./lib/syslib.js');
    
    RED.nodes.registerType("redplc-contact", function(n) {
        const node = this;
        RED.nodes.createNode(node, n);

        node.operation = n.operation;
        node.varname = n.vartype + n.address;
        node.index = syslib.getIndex(n.vartype, n.index, n.counter, n.timer, n.fflop);
        node.name = node.varname + "." + syslib.getIndexName(n.vartype, n.index, n.counter, n.timer, n.fflop);
        node.iserror = false;

        syslib.setStatus(node, node.name);

        node.on("input", (msg) => {
            var payload_in = syslib.getPayloadBool(node, msg);

            if (payload_in === undefined)
                return;
            
            if (node.ctxvar === undefined) {
                node.ctxvar = syslib.getVariable(node, node.varname, node.index);

                if (node.ctxvar === undefined) {
                    node.iserror = true;
                    msg.payload = false;
                    node.send(msg);
                    return;
                }
            }

            var value = node.ctxvar[node.index];

            switch (node.operation) {
                case "NO":
                    msg.payload = value ? payload_in : false;
                    break;
                case "NC":
                    msg.payload = !value ? payload_in : false;
                    break;
                case "P":
                    msg.payload = syslib.posEdge(node, value) ? payload_in : false;
                    break;
                case "N":
                    msg.payload = syslib.negEdge(node, value) ? payload_in : false;
                    break;
            }
            
            syslib.setStatusBool(node, msg.payload, node.name + " : " + Number(value));
            node.send(msg);
        });
    });
}
