module.exports = function(RED) {
    const { exec } = require('child_process');

    function StopOLEDNode(config) {
        RED.nodes.createNode(this, config);
        const node = this;

        node.on('input', function(msg) {
            // Executar la comanda per aturar el servei OLED
            exec('sudo systemctl stop oled_head', (error, stdout, stderr) => {
                if (error) {
                    node.error(`Error aturant el servei OLED: ${error.message}`);
                    msg.payload = {
                        success: false,
                        message: `Error: ${error.message}`,
                        stderr: stderr,
                        stdout: stdout
                    };
                    node.status({fill:"red", shape:"dot", text:"error"});
                } else {
                    node.log('Servei OLED aturat correctament');
                    msg.payload = {
                        success: true,
                        message: 'Servei OLED aturat correctament',
                        stderr: stderr,
                        stdout: stdout
                    };
                    node.status({fill:"green", shape:"dot", text:"aturat"});
                }
                
                // Enviar el missatge amb el resultat
                node.send(msg);
                
                // Esborrar l'estat després de 3 segons
                setTimeout(() => {
                    node.status({});
                }, 3000);
            });
        });

        node.on('close', function() {
            node.status({});
        });
    }

    RED.nodes.registerType("stop-oled", StopOLEDNode);
}
