/**
 * openbus.js
 * Node de Node-RED per obrir el bus I2C
 */

module.exports = function(RED) {
    const iotv4 = require('./i2c-iotv4');

    function OpenBusNode(config) {
        RED.nodes.createNode(this, config);
        const node = this;

        node.on('input', async function(msg) {
            try {
                // Comprova si el bus ja està obert
                if (iotv4.isBusOpen()) {
                    node.warn('El bus I2C ja està obert');
                    msg.payload = {
                        success: false,
                        message: 'El bus I2C ja està obert',
                        alreadyOpen: true
                    };
                    node.send(msg);
                    return;
                }

                // Obre el bus I2C
                await iotv4.openBus();
                
                node.status({fill: "green", shape: "dot", text: "Bus obert"});
                
                msg.payload = {
                    success: true,
                    message: 'Bus I2C obert correctament',
                    timestamp: new Date().toISOString()
                };
                
                node.send(msg);
                
            } catch (error) {
                node.status({fill: "red", shape: "ring", text: "Error"});
                node.error(`Error obrint el bus I2C: ${error.message}`, msg);
                
                msg.payload = {
                    success: false,
                    error: error.message
                };
                
                node.send(msg);
            }
        });

        node.on('close', function(done) {
            node.status({});
            done();
        });
    }

    RED.nodes.registerType("openbus", OpenBusNode);
};
