/**
 * Node-RED node: getdsetup
 * Llegeix la configuració actual del RIB Digital
 */

module.exports = function(RED) {
    const { getdsetup } = require('./i2c-iotv4');

    function GetdsetupNode(config) {
        RED.nodes.createNode(this, config);
        const node = this;
        
        // Configuració del node
        const defaultAddr = config.addr || "0000";

        node.on('input', async function(msg) {
            try {
                let addr = defaultAddr;
                
                // Prioritat: si payload és un objecte amb addr, usar-lo
                if (msg.payload && typeof msg.payload === 'object' && !Array.isArray(msg.payload)) {
                    if (msg.payload.addr) {
                        addr = msg.payload.addr;
                    }
                }
                // Si payload és true, false o timestamp, usar addr de configuració
                // (que ja està assignat per defecte)

                node.status({fill: "blue", shape: "dot", text: "llegint configuració..."});

                // Crida a la funció getdsetup
                const result = await getdsetup(addr);

                // Prepara la sortida
                msg.payload = {
                    addr: addr,
                    binary: result.binary,
                    modes: result.modes,
                    description: result.log
                };

                const modesSummary = result.modes.length > 0 ? result.modes.join(', ') : 'No modes';
                node.status({fill: "green", shape: "dot", text: modesSummary.substring(0, 30)});
                node.send(msg);

            } catch (error) {
                node.error(`Error en getdsetup: ${error.message}`);
                node.status({fill: "red", shape: "ring", text: "error"});
                msg.payload = { error: error.message };
                node.send(msg);
            }
        });
    }

    RED.nodes.registerType("getdsetup", GetdsetupNode);
}
