/**
 * Node-RED node: getasetup
 * Llegeix la configuració del RIB Analògic
 */

module.exports = function(RED) {
    const { getasetup } = require('./i2c-iotv4');

    function GetasetupNode(config) {
        RED.nodes.createNode(this, config);
        const node = this;
        
        // Configuració del node
        const defaultAddr = config.addr || "0000";

        node.on('input', async function(msg) {
            try {
                let addr = defaultAddr;
                
                // Prioritat: si payload és un objecte amb addr, usar-lo
                if (msg.payload && typeof msg.payload === 'object' && !Array.isArray(msg.payload)) {
                    if (msg.payload.addr) {
                        addr = msg.payload.addr;
                    }
                }
                // Si payload és true, false o timestamp, usar addr de configuració
                // (que ja està assignat per defecte)

                node.status({fill: "blue", shape: "dot", text: "llegint setup..."});

                // Crida a la funció getasetup
                const result = await getasetup(addr);

                // Prepara la sortida
                msg.payload = {
                    addr: addr,
                    binary: result.binary,
                    modes: result.modes,
                    description: result.description
                };

                node.status({fill: "green", shape: "dot", text: result.binary});
                node.send(msg);

            } catch (error) {
                node.error(`Error en getasetup: ${error.message}`);
                node.status({fill: "red", shape: "ring", text: "error"});
                msg.payload = { error: error.message };
                node.send(msg);
            }
        });
    }

    RED.nodes.registerType("getasetup", GetasetupNode);
}
