/**
 * Node-RED node: dversion
 * Llegeix la versió del RIB Digital
 */

module.exports = function(RED) {
    const { dversion } = require('./i2c-iotv4');

    function DversionNode(config) {
        RED.nodes.createNode(this, config);
        const node = this;
        
        // Configuració del node
        const defaultAddr = config.addr || "0000";

        node.on('input', async function(msg) {
            try {
                let addr = defaultAddr;
                
                // Prioritat: si payload és un objecte amb addr, usar-lo
                if (msg.payload && typeof msg.payload === 'object' && !Array.isArray(msg.payload)) {
                    if (msg.payload.addr) {
                        addr = msg.payload.addr;
                    }
                }
                // Si payload és true, false o timestamp, usar addr de configuració
                // (que ja està assignat per defecte)

                node.status({fill: "blue", shape: "dot", text: "llegint versió..."});

                // Crida a la funció dversion
                const result = await dversion(addr);

                // Prepara la sortida
                msg.payload = {
                    addr: addr,
                    major: result.major,
                    minor: result.minor,
                    version: `${result.major}.${result.minor}`,
                    binary: result.binary
                };

                node.status({fill: "green", shape: "dot", text: `v${result.major}.${result.minor}`});
                node.send(msg);

            } catch (error) {
                node.error(`Error en dversion: ${error.message}`);
                node.status({fill: "red", shape: "ring", text: "error"});
                msg.payload = { error: error.message };
                node.send(msg);
            }
        });
    }

    RED.nodes.registerType("dversion", DversionNode);
}
