# node-red-contrib-i2c-iotv

Nodes de Node-RED per a la gestió de dispositius I2C IoT (RIB Digital/Analog).

## Instal·lació

### Opció 1: Instal·lació des de Node-RED

1. Obre l'editor de Node-RED
2. Ves al menú (≡) → Manage palette
3. A la pestanya "Install", cerca `node-red-contrib-i2c-iotv`
4. Fes clic a "Install"

### Opció 2: Instal·lació manual

1. Navega al directori d'usuari de Node-RED (normalment `~/.node-red`)
2. Executa:
```bash
npm install node-red-contrib-i2c-iotv
```

### Opció 3: Instal·lació local per a desenvolupament

1. Clona o copia els fitxers en una carpeta
2. Assegura't que el fitxer `i2c-iotv4.js` està a la mateixa carpeta
3. Al directori del paquet, executa:
```bash
npm install
npm link
```
4. Al directori d'usuari de Node-RED (`~/.node-red`):
```bash
npm link node-red-contrib-i2c-iotv
```
5. Reinicia Node-RED

## Estructura de fitxers

```
node-red-contrib-i2c-iotv/
├── package.json
├── i2c-iotv4.js          # Biblioteca I2C v4 (amb gestió persistent del bus)
├── openbus.js            # Node: Obre el bus I2C
├── openbus.html          # UI del node
├── closebus.js           # Node: Tanca el bus I2C
├── closebus.html         # UI del node
├── dversion.js           # Node: Llegeix versió digital
├── dversion.html         # UI del node
├── dout.js               # Node: Sortida digital 8 bits
├── dout.html             # UI del node
├── doutbit.js            # Node: Sortida d'un bit
├── doutbit.html          # UI del node
├── din.js                # Node: Entrada digital 8 bits
├── din.html              # UI del node
├── getdsetup.js          # Node: Llegeix configuració
├── getdsetup.html        # UI del node
├── dsetup.js             # Node: Estableix configuració
├── dsetup.html           # UI del node
└── README.md             # Aquest fitxer
```

## Nodes disponibles

Tots els nodes es troben a la categoria **i2c-iotv** a la paleta de Node-RED.

### openbus
Obre el bus I2C per a futures operacions.

**⚠️ IMPORTANT:** Aquest node ha de ser el primer en executar-se abans d'utilitzar qualsevol altre node d'I2C.

**Entrada:**
```json
{}
```

**Sortida:**
```json
{
  "success": true,
  "message": "Bus I2C obert correctament",
  "timestamp": "2025-10-16T10:30:00.000Z"
}
```

### closebus
Tanca el bus I2C alliberant els recursos.

**⚠️ IMPORTANT:** Aquest node hauria de ser l'últim en executar-se quan ja no necessitis el bus I2C.

**Entrada:**
```json
{}
```

**Sortida:**
```json
{
  "success": true,
  "message": "Bus I2C tancat correctament",
  "timestamp": "2025-10-16T10:35:00.000Z"
}
```

### dversion
Llegeix la versió del RIB Digital.

**Entrada:**
```json
{"addr": "0000"}
```

**Sortida:**
```json
{
  "major": 1,
  "minor": 2,
  "version": "1.2",
  "binary": "0000000100000010"
}
```

### dout
Escriu una sortida digital de 8 bits.

**Entrada:**
```json
{"addr": "0000", "side": "B", "value": 255}
```

**Sortida:**
```json
{
  "addr": "0000",
  "side": "B",
  "value": 255,
  "hex": "0xFF",
  "binary": "11111111",
  "success": true
}
```

### doutbit
Escriu un sol bit de la sortida digital.

**Entrada:**
```json
{"addr": "0000", "side": "B", "posbyte": 7, "value": 1}
```

**Sortida:**
```json
{
  "addr": "0000",
  "side": "B",
  "posbyte": 7,
  "value": 1,
  "success": true
}
```

### din
Llegeix una entrada digital de 8 bits.

**Entrada:**
```json
{"addr": "0000", "side": "A"}
```

**Sortida:**
```json
{
  "addr": "0000",
  "side": "A",
  "binary": "11111111",
  "decimal": 255,
  "hex": "0xFF"
}
```

### getdsetup
Llegeix la configuració actual del RIB Digital.

**Entrada:**
```json
{"addr": "0000"}
```

**Sortida:**
```json
{
  "addr": "0000",
  "binary": "00100011",
  "modes": ["A digital output", "B digital input"],
  "description": "A digital output, B digital input"
}
```

### dsetup
Estableix la configuració del RIB Digital.

**Entrada:**
```json
{"addr": "0000", "modeA": "aout", "modeB": "bin"}
```

**Modes vàlids:**
- **modeA**: `ain`, `aout`, `aoutpwm`
- **modeB**: `bin`, `bout`, `boutpwm`, `bintouch`

**Sortida:**
```json
{
  "addr": "0000",
  "modeA": "aout",
  "modeB": "bin",
  "success": true,
  "message": "Configuració establerta correctament"
}
```

## Nodes de control del sistema

Aquests nodes es troben a la categoria **IoTv system** i permeten controlar serveis del sistema operatiu.

### stop-oled
Atura el servei OLED del sistema operatiu.

**Entrada:**
```json
{}
```

**Sortida:**
```json
{
  "success": true,
  "message": "Servei OLED aturat correctament",
  "stdout": "",
  "stderr": ""
}
```

**⚠️ Requisit:** L'usuari de Node-RED ha de tenir permisos sudo sense contrasenya per a systemctl.

### start-oled
Inicia el servei OLED del sistema operatiu.

**Entrada:**
```json
{}
```

**Sortida:**
```json
{
  "success": true,
  "message": "Servei OLED iniciat correctament",
  "stdout": "",
  "stderr": ""
}
```

**⚠️ Requisit:** L'usuari de Node-RED ha de tenir permisos sudo sense contrasenya per a systemctl.

## Exemple de flux complet

```json
[
  {
    "id": "inject_open",
    "type": "inject",
    "payload": "{}",
    "payloadType": "json",
    "topic": "",
    "once": true,
    "wires": [["openbus1"]]
  },
  {
    "id": "openbus1",
    "type": "openbus",
    "name": "Obrir bus I2C",
    "wires": [["dversion1"]]
  },
  {
    "id": "dversion1",
    "type": "dversion",
    "name": "Llegir versió",
    "wires": [["debug1", "dout1"]]
  },
  {
    "id": "dout1",
    "type": "dout",
    "name": "Escriure sortida",
    "wires": [["closebus1"]]
  },
  {
    "id": "closebus1",
    "type": "closebus",
    "name": "Tancar bus I2C",
    "wires": [["debug2"]]
  },
  {
    "id": "debug1",
    "type": "debug",
    "name": "Versió"
  },
  {
    "id": "debug2",
    "type": "debug",
    "name": "Bus tancat"
  }
]
```

## Ordre d'ús dels nodes

1. **openbus** - Primer de tot, obre el bus I2C
2. **altres nodes** - Realitza les operacions necessàries (dversion, dout, din, etc.)
3. **closebus** - Al final, tanca el bus I2C

**Important:** No oblidis sempre tancar el bus quan acabis. El bus ha d'estar obert durant totes les operacions I2C.

## Avantatges de la versió v4

La biblioteca `i2c-iotv4.js` utilitza una gestió persistent del bus I2C:

- **Millor rendiment**: El bus s'obre una sola vegada i es reutilitza
- **Més fiabilitat**: Evita problemes de lectures incorrectes per obertures/tancaments continus
- **Gestió explícita**: Control total sobre quan el bus està obert o tancat
- **Menys overhead**: Redueix la càrrega del sistema

## Requisits

- Node-RED v1.0 o superior
- Node.js v12 o superior
- Paquet `i2c-bus` (s'instal·la automàticament)
- I2C habilitat a la Raspberry Pi

## Habilitar I2C a Raspberry Pi

```bash
sudo raspi-config
# Interfacing Options → I2C → Yes
sudo reboot
```

## Llicència

MIT

## Autor

Jordi B

## Suport

Per a problemes o preguntes, obre un issue al repositori del projecte.
