# CHANGELOG - node-red-contrib-i2c-iotv

## [1.1.18] - 2025-11-11

### 🔧 Nous Nodes de Control del Sistema

**Afegits nodes per controlar el servei OLED del sistema operatiu**

#### Nous nodes:

1. **stop-oled**
   - Executa: `sudo systemctl stop oled_head`
   - Categoria: IoTv system
   - Icona: stop-circle (vermell)
   - Retorna objecte amb estat de l'operació (success, message, stdout, stderr)

2. **start-oled**
   - Executa: `sudo systemctl start oled_head`
   - Categoria: IoTv system
   - Icona: play-circle (verd)
   - Retorna objecte amb estat de l'operació (success, message, stdout, stderr)

#### Funcionalitats:

- ✅ Control del servei OLED des de Node-RED
- ✅ Feedback visual amb status nodes (verd/vermell)
- ✅ Sortida d'informació completa sobre l'execució
- ✅ Gestió d'errors integrada
- ✅ Status temporal (s'esborra després de 3 segons)

#### Requisits:

- L'usuari de Node-RED ha de tenir permisos sudo sense contrasenya per a systemctl
- O bé el servei ha d'estar configurat per permetre l'inici/aturada sense sudo

---

## [1.1.15] - 2025-11-05

### 🚀 Optimitzacions Funcions Analògiques

**Extensió de l'optimització a ain/aout i altres funcions auxiliars**

#### Problema Detectat:

Les funcions analògiques (**ain**, **aout**) i altres funcions auxiliars no tenien les mateixes proteccions optimitzades que les funcions digitals:

1. **readWordDouble()** (usat per `ain`):
   - ❌ NO tenia delay entre lectures
   - ⚠️ Risc d'errors similars als de `din` sense protecció

2. **readByteDouble()** (usat per `getdsetup`, `aversion`, etc.):
   - ❌ Delay excessiu: 20ms + 10ms = 30ms total
   - ⚠️ Molt més lent que necessari

#### Canvis realitzats:

1. **readWordDouble()** - Afegit delay entre lectures
   - Abans: 0ms delay (sense protecció)
   - Ara: 1ms delay entre lectures
   - Justificació: Mateixa protecció que `din`

2. **readByteDouble()** - Optimitzat delay
   - Abans: 30ms total (20ms + 10ms)
   - Ara: 1ms delay entre lectures
   - Justificació: Coherència amb `readByteCleanSimple`

#### Impacte:

- **ain()** / **ainv()**: Ara protegit amb delay 1ms (abans sense protecció)
- **aversion()**: Optimitzat de 30ms a 1ms (29ms més ràpid)
- **getdsetup()**: Optimitzat de 30ms a 1ms (29ms més ràpid)
- **dversion()**: Optimitzat de 30ms a 1ms (29ms més ràpid)

#### Fiabilitat:

- ✅ Les funcions analògiques ara tenen la mateixa protecció que les digitals
- ✅ Coherència en tots els mètodes de lectura I2C
- ✅ Millora de rendiment sense comprometre fiabilitat

---

## [1.1.14] - 2025-11-05

### 🚀 Optimitzacions de Rendiment

**Millora del cicle I2C en ~12% (de ~42ms a ~37ms)**

#### Canvis realitzats:

1. **Eliminat delay inicial en funció `din()`**
   - Abans: 2ms de delay inicial
   - Ara: 0ms (delay eliminat)
   - Justificació: Els tests extensius demostren que no és necessari per la fiabilitat

2. **Optimitzat delay entre lectures en `readByteCleanSimple()`**
   - Abans: 5ms entre primera i segona lectura
   - Ara: 1ms entre lectures
   - Justificació: Tests amb 300+ cicles mostren 0% d'errors amb 1ms
   - Es manté la doble lectura amb descart de la primera (essencial per fiabilitat)

#### Resultats dels tests:

- **Cicle anterior**: ~42.1ms
- **Cicle optimitzat**: ~37.5ms
- **Millora**: 4.6ms (~11-12% més ràpid)
- **Fiabilitat**: 0% d'errors en tests de 500+ cicles
- **Cicle mínim viable**: 40ms amb marge de seguretat
- **Cicle recomanat**: 50ms (ample marge, 12.5ms lliures)

#### Compatibilitat:

- ✅ Totalment compatible amb versions anteriors
- ✅ Mantinença de la doble lectura (obligatòria després de dout)
- ✅ Mateix comportament, només més ràpid
- ✅ No requereix canvis en flows de Node-RED existents

#### Notes tècniques:

Els tests van demostrar que:
- La **primera lectura després de dout sempre retorna 0x41** (brossa del buffer I2C)
- La **segona lectura sempre és correcta** (després de 1ms mínim)
- Un **delay mínim d'1ms** entre lectures és suficient per netejar el buffer
- El **delay inicial** abans de començar les lectures no aporta valor

#### Tests realitzats:

1. Test de delays amb 8 configuracions diferents (300 cicles cada una)
2. Test de cicle mínim amb binary search (1000+ cicles)
3. Test de fiabilitat en cicle continu (500+ cicles)
4. Test de necessitat de doble lectura (250+ cicles en 4 escenaris)
5. Test de delays en paral·lel (1400+ cicles amb diferents delays)

**Total: >3500 cicles testejats amb 0% d'errors en configuració optimitzada**

---

## [1.1.13] - 2025-11-04

### Canvis previs
- Reducció inicial de delays de 10ms a 2ms (inicial) i 5ms (entre lectures)
- Implementació de doble lectura amb descart de primera

---

## Informació de les versions

Les versions segueixen el format: MAJOR.MINOR.PATCH

- **MAJOR**: Canvis incompatibles amb versions anteriors
- **MINOR**: Noves funcionalitats compatibles
- **PATCH**: Correccions d'errors i optimitzacions

Aquesta versió 1.1.14 és una **PATCH** que només optimitza el rendiment sense afectar la funcionalitat.
